<?php

namespace App\Http\Controllers\Api\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;

class UserPermissionController extends Controller
{
    // Assign Permission to User
    public function givePermission(Request $request, $userId)
    {
        $request->validate([
            'permission' => 'required|string|exists:permissions,name'
        ]);

        $user = User::findOrFail($userId);
        $user->givePermissionTo($request->permission);

        return response()->json([
            'status' => true,
            'message' => "Permission '{$request->permission}' assigned to user '{$user->name}'.",
            'data' => $user->permissions
        ]);
    }

    // Revoke Permission from User
    public function revokePermission(Request $request, $userId)
    {
        $request->validate([
            'permission' => 'required|string|exists:permissions,name'
        ]);

        $user = User::findOrFail($userId);
        $user->revokePermissionTo($request->permission);

        return response()->json([
            'status' => true,
            'message' => "Permission '{$request->permission}' revoked from user '{$user->name}'.",
            'data' => $user->permissions
        ]);
    }

    // Sync Permissions for User
    public function syncPermissions(Request $request, $userId)
    {
        $request->validate([
            'permissions' => 'required|array',
            'permissions.*' => 'string|exists:permissions,name'
        ]);

        $user = User::findOrFail($userId);
        $user->syncPermissions($request->permissions);

        return response()->json([
            'status' => true,
            'message' => "Permissions synced for user '{$user->name}'.",
            'data' => $user->permissions
        ]);
    }

    // Get all permissions of a User
    public function getPermissions($userId)
    {
        $user = User::findOrFail($userId);

        return response()->json([
            'status' => true,
            'data' => $user->permissions
        ]);
    }
}
