<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Designation;
use Illuminate\Http\Request;

class DesignationController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $designations = Designation::get();
        return response()->json([
            'status' => true,
            'data' => $designations
        ]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'description' => 'nullable|string'          
        ]);

        $designation = Designation::create($request->all());

        return response()->json([
            'status' => true,
            'message' => 'Designation created successfully.',
            'data' => $designation
        ], 201);
    }

    /**
     * Display the specified resource.
     */
    public function show($id)
    {
        $designation = Designation::find($id);

        if (!$designation) {
            return response()->json([
                'status' => false,
                'message' => 'Designation not found.'
            ], 404);
        }

        return response()->json([
            'status' => true,
            'data' => $designation
        ]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id)
    {
        $designation = Designation::find($id);

        if (!$designation) {
            return response()->json([
                'status' => false,
                'message' => 'Designation not found.'
            ], 404);
        }

        $request->validate([
            'name' => 'required|string|max:255',
            'description' => 'nullable|string',
            'status' => 'in:active,inactive'
        ]);

        $designation->update($request->all());

        return response()->json([
            'status' => true,
            'message' => 'Designation updated successfully.',
            'data' => $designation
        ]);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        $designation = Designation::find($id);

        if (!$designation) {
            return response()->json([
                'status' => false,
                'message' => 'Designation not found.'
            ], 404);
        }

        $designation->delete();

        return response()->json([
            'status' => true,
            'message' => 'Designation deleted successfully.'
        ]);
    }
}
