<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class NotificationController extends Controller
{
    /**
     * Get all notifications for the authenticated user.
     */
    public function index(Request $request)
    {
        $notifications = $request->user()->notifications()->paginate($request->get('per_page', 20));

        return response()->json([
            'status' => true,
            'data' => $notifications,
            'unread_count' => $request->user()->unreadNotifications()->count()
        ]);
    }

    /**
     * Get unread notifications for the authenticated user.
     */
    public function unread(Request $request)
    {
        $notifications = $request->user()->unreadNotifications;

        return response()->json([
            'status' => true,
            'data' => $notifications,
            'unread_count' => $notifications->count()
        ]);
    }

    /**
     * Mark a specific notification as read.
     */
    public function markAsRead(Request $request, $id)
    {
        $notification = $request->user()->notifications()->findOrFail($id);
        $notification->markAsRead();

        return response()->json([
            'status' => true,
            'message' => 'Notification marked as read.'
        ]);
    }

    /**
     * Mark all notifications as read.
     */
    public function markAllAsRead(Request $request)
    {
        $request->user()->unreadNotifications->markAsRead();

        return response()->json([
            'status' => true,
            'message' => 'All notifications marked as read.'
        ]);
    }
}
