<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class ProductSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Schema::disableForeignKeyConstraints();
        DB::table('products')->truncate();

        $products = [
            [2, 4, 2, 'Lantha Plus', '500 ml', '2027-09-30', 240, 550, 500, 1716, NULL, '2025-02-13 05:03:33', '2026-02-18 21:39:50'],
            [3, 2, 8, 'Aromec 3%', '100 ml', '2028-08-01', 105, 250, 227, -9, NULL, '2025-02-18 04:48:28', '2026-02-19 00:04:05'],
            [4, 2, 8, 'Aromec 3%', '500 ml', '2027-08-01', 460, 1100, 1000, 1, NULL, '2025-02-18 04:51:32', '2026-02-20 23:31:08'],
            [5, 2, 12, 'Aromec Pro Plus', '100 ml', '2026-10-13', 55, 215, 195, 391, NULL, '2025-02-18 04:54:24', '2026-02-21 21:03:27'],
            [6, 2, 12, 'Aromec Pro Plus', '500 ml', '2026-10-13', 205, 770, 700, 210, NULL, '2025-02-18 04:55:21', '2026-02-21 21:42:16'],
            [7, 4, 11, 'A Tox Plus', '500 ml', '2026-06-30', 150, 590, 536, 263, NULL, '2025-02-18 04:56:32', '2026-02-21 04:20:03'],
            [8, 4, 11, 'A Tox Plus', '1 liter', '2026-06-30', 280, 1150, 1045, 22, NULL, '2025-02-18 04:57:32', '2026-02-21 04:20:03'],
            [9, 4, 2, 'Bromex', '100 ml', '2025-02-18', 348, 620, 620, 0, NULL, '2025-02-18 04:59:00', '2025-11-15 01:24:03'],
            [10, 4, 2, 'Bromex', '500 ml', '2025-02-18', 1428, 2550, 2550, 0, NULL, '2025-02-18 05:00:47', '2025-11-15 01:24:03'],
            [11, 4, 2, 'BT Stop', '100 ml', '2027-09-30', 40, 110, 100, 3126, NULL, '2025-02-18 05:01:44', '2026-02-19 03:35:35'],
            [12, 4, 2, 'BT Stop', '200 ml', '2025-02-10', 70, 195, 177, 0, NULL, '2025-02-18 05:03:01', '2026-02-09 22:02:54'],
            [13, 3, 2, 'Cal Plus AD3', '500 ml', '2027-03-31', 115, 235, 214, 28, NULL, '2025-02-18 05:04:17', '2026-02-17 00:39:49'],
            [14, 3, 2, 'Cal Plus AD3', '1 liter', '2027-03-31', 189, 410, 373, 254, NULL, '2025-02-18 05:05:15', '2026-02-18 22:29:13'],
            [15, 3, 2, 'Cal Plus AD3', '5 liter', '2027-12-31', 742, 1650, 1500, 0, NULL, '2025-02-18 05:06:04', '2026-02-17 00:39:49'],
            [16, 4, 9, 'Cipro-200', '500 ml', '2026-09-30', 703, 1875, 1705, 47, NULL, '2025-02-18 05:07:07', '2026-02-20 22:33:54'],
            [17, 4, 9, 'Diclacox', '100 ml', '2028-09-30', 250, 590, 536, 0, NULL, '2025-02-18 05:08:12', '2026-02-14 06:17:45'],
            [18, 4, 9, 'Diclacox', '500 ml', '2028-02-29', 1200, 2880, 2618, 0, NULL, '2025-02-18 05:09:15', '2025-11-11 22:28:02'],
            [19, 4, 13, 'Dironil DS', '100 gm', '2027-04-30', 50, 130, 118, 935, NULL, '2025-02-18 05:10:18', '2026-02-19 03:45:38'],
            [20, 2, 2, 'Eco Green', '2 kg', '2025-12-31', 230, 670, 610, 227, NULL, '2025-02-18 05:11:01', '2026-02-20 23:38:11'],
            [22, 3, 9, 'Ferti Bolus', '7x10s', '2027-12-31', 100, 300, 273, 21, NULL, '2025-02-18 05:13:03', '2026-02-19 03:35:35'],
            [23, 3, 2, 'Fix AI', '225 ml', '2027-10-31', 135, 200, 182, 927, NULL, '2025-02-18 05:13:44', '2026-02-19 06:52:12'],
            [24, 4, 9, 'Flor-200', '500 ml', '2027-02-28', 1950, 3650, 3318, 0, NULL, '2025-02-18 05:14:50', '2026-02-14 21:59:35'],
            [25, 4, 3, 'Flor-200', '100 ml', '2025-02-10', 420, 850, 0, 0, NULL, '2025-02-18 05:16:02', '2025-07-12 10:11:33'],
            [26, 4, 6, 'Genta Cure Vet', '100 gm', '2027-05-31', 190, 690, 627, 297, NULL, '2025-02-18 05:16:46', '2026-02-20 23:10:51'],
            [27, 4, 6, 'Genta Cure Vet', '500 gm', '2027-01-31', 875, 3250, 2955, 0, NULL, '2025-02-18 05:18:38', '2026-01-13 21:56:52'],
            [28, 4, 6, 'G-Nill', '100 ml', '2026-09-30', 95, 250, 227, -2, NULL, '2025-02-18 05:19:21', '2026-01-29 04:58:12'],
            [29, 4, 6, 'G-Nill', '500 ml', '2027-09-30', 425, 1140, 1036, 15, NULL, '2025-02-18 05:20:07', '2026-02-18 21:41:24'],
            [30, 4, 11, 'Grow Booster', '500 ml', '2027-11-30', 220, 550, 500, -1, NULL, '2025-02-18 05:20:53', '2026-02-09 23:36:55'],
            [32, 4, 11, 'Liso Stem', '100 gm', '2028-11-30', 130, 420, 382, 52, NULL, '2025-02-18 05:23:08', '2026-02-21 01:07:16'],
            [33, 4, 2, 'Liv Gold Plus', '100 ml', '2027-12-31', 30, 90, 82, 2022, NULL, '2025-02-18 05:23:53', '2026-02-18 21:42:32'],
            [34, 4, 3, 'Liv Gold Plus', '500 ml', '2027-12-31', 135, 330, 300, 3069, NULL, '2025-02-18 05:24:39', '2026-02-20 23:07:41'],
            [35, 3, 9, 'Masti Uro Tube', '4x1s', '2025-02-17', 392, 800, 727, 0, NULL, '2025-02-18 05:25:52', '2025-09-12 23:02:45'],
            [36, 4, 11, 'Neo Cure Vet-70%', '100 gm', '2027-02-28', 106, 350, 318, 0, NULL, '2025-03-02 23:31:03', '2026-02-03 01:18:01'],
            [37, 4, 11, 'Neo Cure Vet-70%', '1 kg', '2027-02-28', 1500, 2550, 3045, -1, NULL, '2025-03-02 23:31:54', '2026-02-10 01:02:51'],
            [38, 4, 2, 'Nephro clean', '100 ml', '2027-03-31', 53, 185, 168, 2009, NULL, '2025-03-02 23:32:42', '2026-01-30 23:04:53'],
            [39, 4, 2, 'Nephro clean', '500 ml', '2027-03-31', 135, 790, 718, 3536, NULL, '2025-03-02 23:33:25', '2026-02-19 03:52:56'],
            [40, 4, 9, 'Norflocin020', '500 ml', '2027-01-31', 680, 1460, 1327, 42, NULL, '2025-03-02 23:34:18', '2026-02-18 00:38:54'],
            [41, 4, 9, 'Nutri stim', '1 kg', '2027-11-30', 205, 460, 419, 0, NULL, '2025-03-02 23:35:18', '2025-09-10 08:08:13'],
            [42, 2, 12, 'Tab Oxy Grow', '1 kg', '2027-07-31', 240, 510, 420, 21, NULL, '2025-03-02 23:36:14', '2026-02-19 03:35:35'],
            [43, 2, 12, 'Tab Oxy Grow', '25 kg', '2027-08-31', 4750, 10588, 9625, 0, NULL, '2025-03-02 23:37:03', '2026-01-13 01:15:15'],
            [44, 2, 8, 'P-Clean', '100 ml', '2027-10-31', 75, 230, 192, 294, NULL, '2025-03-02 23:37:42', '2026-02-20 23:38:11'],
            [45, 2, 8, 'P-Clean', '250 ml', '2027-03-31', 160, 530, 442, 0, NULL, '2025-03-02 23:38:16', '2026-02-15 03:15:28'],
            [46, 2, 8, 'P-Clean', '500 ml', '2027-03-31', 305, 1030, 858, 9, NULL, '2025-03-02 23:38:55', '2026-02-20 23:38:11'],
            [47, 2, 8, 'P-Clean', '5 liter', '2026-10-31', 3000, 9800, 8181, 0, NULL, '2025-03-02 23:39:50', '2026-02-19 00:04:05'],
            [48, 2, 8, 'Pro-8', '100 gm', '2027-11-30', 210, 540, 491, 189, NULL, '2025-03-02 23:41:44', '2026-02-15 22:41:46'],
            [49, 2, 2, 'Tilmicodem-20', '100 ml', '2027-09-30', 504, 900, 818, 0, NULL, '2025-03-02 23:42:36', '2025-09-13 00:58:40'],
            [50, 3, 2, 'UR Vet', '500 ml', '2027-11-30', 140, 330, 300, 1468, NULL, '2025-03-02 23:43:34', '2026-02-18 21:42:32'],
            [51, 4, 2, 'Vermicid', '100 ml', '2027-09-30', 157, 320, 0, 0, NULL, '2025-03-02 23:44:25', '2025-11-15 01:23:54'],
            [52, 4, 2, 'Vermicid', '500 ml', '2027-09-30', 672, 1370, 0, 0, NULL, '2025-03-02 23:45:10', '2025-11-15 01:24:03'],
            [53, 3, 2, 'Viral Free', '100 ml', '2028-02-29', 74, 250, 227, 103, NULL, '2025-03-02 23:45:57', '2026-02-18 01:13:10'],
            [54, 3, 2, 'Viral Free', '250 ml', '2027-09-30', 115, 560, 509, 1786, NULL, '2025-03-02 23:46:43', '2026-02-21 01:07:16'],
            [55, 3, 2, 'Viral Free', '500 ml', '2028-02-29', 223, 1027, 934, 1144, NULL, '2025-03-02 23:48:21', '2026-02-19 03:52:56'],
            [56, 4, 2, 'Zero Cox', '250 ml', '2027-09-30', 162, 450, 409, 0, NULL, '2025-03-02 23:51:05', '2025-09-13 00:08:55'],
            [57, 4, 2, 'Zero Cox', '500 ml', '2028-05-31', 297, 850, 773, 594, NULL, '2025-03-02 23:51:40', '2026-01-31 00:24:16'],
            [58, 3, 6, 'Zero Masti', '100 gm', '2027-11-30', 90, 190, 173, 293, NULL, '2025-03-02 23:52:18', '2026-02-19 03:45:38'],
            [59, 3, 10, 'Rad Zinc', '100 ml', '2027-11-30', 33, 37, 34, 549, NULL, '2025-03-03 00:05:08', '2026-02-18 00:12:09'],
            [60, 3, 10, 'Rad Zinc', '500 ml', '2026-06-30', 58, 120, 109, 0, NULL, '2025-03-03 00:05:53', '2026-02-15 02:32:14'],
            [61, 3, 10, 'Rad Zinc', '1 liter', '2028-11-30', 100, 210, 191, 70, NULL, '2025-03-03 00:06:27', '2026-02-21 01:07:16'],
            [62, 3, 10, 'Rad Zinc', '3 liter', '2028-02-29', 265, 590, 536, 144, NULL, '2025-03-03 00:07:05', '2026-02-19 00:21:32'],
            [63, 3, 10, 'Rad Zinc', '5 liter', '2027-11-30', 410, 950, 800, 161, NULL, '2025-03-03 00:07:48', '2026-02-20 23:34:18'],
            [64, 4, 8, 'Radi C', '500 gm', '2027-07-31', 150, 550, 300, 77, NULL, '2025-03-03 00:08:40', '2026-02-18 21:42:32'],
            [65, 3, 11, 'Radi Cal P', '100 ml', '2026-06-30', 31, 45, 41, 205, NULL, '2025-03-03 00:09:22', '2026-02-14 22:12:52'],
            [66, 3, 11, 'Radi Cal P', '500 ml', '2026-01-21', 58, 135, 123, 196, NULL, '2025-03-03 00:10:10', '2026-02-15 02:32:14'],
            [67, 3, 11, 'Radi cal P', '1 liter', '2026-06-30', 100, 230, 209, 12, NULL, '2025-03-03 00:10:49', '2026-02-20 23:34:18'],
            [68, 3, 11, 'Radi Cal P', '3 liter', '2026-06-30', 265, 650, 591, 47, NULL, '2025-03-03 00:11:48', '2026-02-18 01:13:47'],
            [69, 3, 11, 'Radi Cal p', '5 liter', '2027-11-30', 410, 1000, 800, 0, NULL, '2025-03-03 00:13:26', '2026-02-20 22:15:04'],
            [70, 2, 2, 'Radi Fat gold', '1 kg', '2027-09-30', 106, 460, 418, 1542, NULL, '2025-03-03 00:14:10', '2026-02-20 23:34:18'],
            [71, 2, 2, 'Radi Lac Bolus', '1x20s', '2027-09-30', 160, 340, 309, 195, NULL, '2025-03-03 00:15:23', '2026-02-19 03:35:35'],
            [72, 2, 2, 'Radi Lime', '25 kg', '2028-09-30', 360, 650, 600, 0, NULL, '2025-03-03 00:16:12', '2026-02-15 03:15:28'],
            [73, 4, 11, 'Radi Zyme', '100 ml', '2027-11-30', 60, 108, 98, 214, NULL, '2025-03-03 00:18:03', '2026-02-20 22:56:44'],
            [74, 4, 11, 'Radi Zyme', '500 ml', '2027-11-30', 105, 490, 445, 92, NULL, '2025-03-03 00:18:54', '2026-02-20 23:38:11'],
            [75, 4, 11, 'Radi Zyme', '25 kg', '2027-11-30', 6250, 13500, 13500, 2, NULL, '2025-03-03 00:19:43', '2026-02-08 23:18:30'],
            [76, 2, 2, 'Radimix Protein Plus', '1 kg', '2027-09-30', 92, 370, 336, 1235, NULL, '2025-03-03 00:20:40', '2026-02-15 05:16:35'],
            [77, 2, 2, 'Radimix Protein Plus', '25 kg', '2027-09-30', 1714, 7500, 7500, 45, NULL, '2025-03-03 00:21:27', '2026-02-20 23:07:37'],
            [78, 2, 12, 'Radi Zeo Plus', '5 kg', '2028-04-30', 125, 550, 500, 443, NULL, '2025-03-03 00:22:13', '2026-02-20 23:38:11'],
            [79, 4, 11, 'Re-Sel', '100 gm', '2026-06-30', 105, 150, 136, 0, NULL, '2025-03-03 00:22:52', '2025-11-12 03:40:50'],
            [80, 4, 11, 'Re-Sel', '500 gm', '2027-09-30', 260, 650, 591, 0, NULL, '2025-03-03 00:24:34', '2026-02-18 00:34:19'],
            [81, 4, 2, 'Respo Clean', '200 ml', '2027-09-30', 336, 790, 718, 162, NULL, '2025-03-03 00:25:25', '2026-02-18 21:31:52'],
            [82, 2, 2, 'RG-Nill', '100 gm', '2028-03-31', 88, 275, 229, 1005, NULL, '2025-03-03 00:26:22', '2025-10-22 01:01:19'],
            [83, 2, 2, 'RG-Nill', '500 gm', '2028-03-31', 371, 1265, 1054, 357, NULL, '2025-03-03 00:27:10', '2026-01-31 04:09:27'],
            [84, 4, 2, 'Rumi D Vet', '20gx10s', '2027-09-30', 100, 280, 255, 521, NULL, '2025-03-03 00:28:02', '2026-02-18 01:13:47'],
            [85, 3, 6, 'Lactona Bolus', '4x10s', '2026-10-31', 316, 788, 716, 130, NULL, '2025-03-25 04:25:00', '2025-12-23 04:34:01'],
            [86, 3, 6, 'Diavet Bolus', '4x10s', '2026-10-31', 316, 788, 716, 101, NULL, '2025-03-25 04:26:41', '2025-12-23 04:25:00'],
            [87, 3, 6, 'CEFTI-R', '50 ml', '2027-12-31', 655, 1800, 1636, 310, NULL, '2025-03-25 04:27:48', '2026-02-14 22:13:58'],
            [88, 3, 6, 'Feedmin Bolus', '4x10s', '2027-11-30', 324, 788, 716, 29, NULL, '2025-03-25 04:28:53', '2026-02-18 21:41:00'],
            [89, 4, 6, 'EMY Plus', '100 gm', '2028-07-31', 155, 340, 309, 81, NULL, '2025-05-29 05:31:48', '2026-02-18 21:43:00'],
            [90, 4, 13, 'Radi Cool Powder', '100 gm', '2028-02-29', 37, 130, 118, 771, NULL, '2025-05-31 00:07:23', '2025-10-12 23:23:50'],
            [91, 4, 13, 'Radi Cool Powder', '500 gm', '2028-02-29', 160, 550, 500, 38, NULL, '2025-05-31 00:08:45', '2025-09-24 22:04:25'],
            [94, 4, 14, 'SEC-B Vet', '500 ml', '2028-03-31', 230, 640, 582, 4, NULL, '2025-10-01 22:17:59', '2026-02-18 21:39:50'],
            [95, 2, 12, 'Tab Oxy Grow', '12.5 kg', '2027-07-31', 2375, 5294, 4812.5, 3, NULL, '2025-10-04 23:04:01', '2026-02-15 03:15:28'],
            [96, 2, 2, 'xyz', '1 liter', '2025-10-11', 280, 190, 1, 20, NULL, '2025-10-10 22:03:31', '2025-10-10 22:09:33'],
            [97, 3, 2, 'Rad Zinc+B', '500ml', '2028-06-30', 80, 180, 164, 513, NULL, '2025-11-08 23:11:18', '2026-02-18 01:13:47'],
            [98, 3, 2, 'Rad Zinc+B', '200ml', '2028-06-30', 50, 80, 73, 271, NULL, '2025-11-08 23:13:49', '2026-02-20 23:34:18'],
            [99, 3, 3, 'AP-100', '50gm', '2028-06-30', 150, 375, 341, 205, NULL, '2025-11-08 23:17:06', '2026-02-04 22:29:05'],
            [100, 3, 3, 'AP-100', '100gm', '2028-09-30', 300, 730, 664, 324, NULL, '2025-11-08 23:19:54', '2026-02-20 23:10:51'],
            [101, 4, 8, 'Radi C', '1 kg', '2027-10-31', 300, 1050, 600, 0, NULL, '2025-12-15 02:55:42', '2026-02-05 04:35:50'],
            [102, 3, 6, 'INJ. PBS Vet', '50 ml', '2028-08-31', 370, 740, 673, 24, NULL, '2025-12-15 03:19:26', '2026-02-14 23:50:50'],
            [103, 3, 2, 'Radi Fat-99%', '1 kg', '2028-09-30', 230, 540, 491, 587, NULL, '2025-12-15 03:27:25', '2026-02-21 01:07:16'],
            [104, 2, 8, 'P-Clean', '1 liter', '2028-01-01', 600, 2000, 1667, 48, NULL, '2026-02-01 23:41:56', '2026-02-01 23:44:00'],
            [105, 4, 9, 'D-Cocci Kill', '100 ml', '2028-09-30', 250, 590, 536, 417, NULL, '2026-02-14 06:19:51', '2026-02-18 21:39:50'],
            [106, 4, 9, 'D-Cocci Kill', '500 ml', '2028-09-30', 1200, 2880, 2618, 115, NULL, '2026-02-14 06:21:06', '2026-02-14 06:25:16'],
            [107, 3, 2, 'Radi Fat-99%', '25 kg', '2028-02-29', 5700, 14500, 13180, 3, NULL, '2026-02-16 02:40:27', '2026-02-16 02:51:46']
        ];

        foreach ($products as $product) {
            DB::table('products')->updateOrInsert(
                ['id' => $product[0]],
                [
                    'category_id' => $product[1],
                    'brand_id' => $product[2],
                    'name' => $product[3],
                    'pack_size' => $product[4],
                    'expiration_date' => $product[5],
                    'purchase_price' => $product[6],
                    'sale_price' => $product[7],
                    'flat_price' => $product[8],
                    'quantity' => $product[9],
                    'image' => $product[10],
                    'created_at' => $product[11],
                    'updated_at' => $product[12]
                ]
            );
        }

        Schema::enableForeignKeyConstraints();

        $this->command->info('Products imported successfully!');
    }
}
