<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

use App\Http\Controllers\Api\Auth\AuthController;
use App\Http\Controllers\Api\Auth\RoleController;
use App\Http\Controllers\Api\DesignationController;
use App\Http\Controllers\Api\EmployeeDetailController;
use App\Http\Controllers\Api\CustomerController;
use App\Http\Controllers\Api\SupplierController;
use App\Http\Controllers\Api\BrandController;
use App\Http\Controllers\Api\CategoryController;
use App\Http\Controllers\Api\ExpenseCategoryController;
use App\Http\Controllers\Api\ExpenseController;
use App\Http\Controllers\Api\ProductController;
use App\Http\Controllers\Api\StockController;
use App\Http\Controllers\Api\OrderController;
use App\Http\Controllers\Api\Auth\PermissionController;
use App\Http\Controllers\Api\Auth\RolePermissionController;
use App\Http\Controllers\Api\Auth\UserPermissionController;
use App\Http\Controllers\Api\ReportController;
use App\Http\Controllers\Api\DashboardController;
use App\Http\Controllers\Api\NotificationController;

Route::get('/user', function (Request $request) {
    return $request->user();
})->middleware('auth:sanctum');


Route::post('/login', [AuthController::class, 'login']);
Route::post('/register', [AuthController::class, 'register']); // Admin only
Route::post('/logout', [AuthController::class, 'logout'])->middleware('auth:sanctum');
Route::get('/me', [AuthController::class, 'me'])->middleware('auth:sanctum');

Route::middleware(['auth:sanctum'])->group(function () {
    Route::get('/roles', [RoleController::class, 'index']);       // List all roles
    Route::post('/roles', [RoleController::class, 'store']);      // Create role
    Route::get('/roles/{id}', [RoleController::class, 'show']);  // Show single role
    Route::put('/roles/{id}', [RoleController::class, 'update']); // Update role
    Route::delete('/roles/{id}', [RoleController::class, 'destroy']); // Delete role
});

Route::middleware(['auth:sanctum'])->group(function () {
    Route::get('/permissions', [PermissionController::class, 'index']);       // List all permissions
    Route::post('/permissions', [PermissionController::class, 'store']);      // Create permission
    Route::get('/permissions/{id}', [PermissionController::class, 'show']);  // Show single permission
    Route::put('/permissions/{id}', [PermissionController::class, 'update']); // Update permission
    Route::delete('/permissions/{id}', [PermissionController::class, 'destroy']); // Delete permission
});

Route::middleware(['auth:sanctum'])->group(function () {
    // Role → Permission APIs
    Route::post('/roles/{id}/give-permission', [RolePermissionController::class, 'givePermission']);
    Route::post('/roles/{id}/revoke-permission', [RolePermissionController::class, 'revokePermission']);
    Route::post('/roles/{id}/sync-permissions', [RolePermissionController::class, 'syncPermissions']);
    Route::get('/roles/{id}/permissions', [RolePermissionController::class, 'getPermissions']);

    // User → Permission APIs
    Route::post('/users/{id}/give-permission', [UserPermissionController::class, 'givePermission']);
    Route::post('/users/{id}/revoke-permission', [UserPermissionController::class, 'revokePermission']);
    Route::post('/users/{id}/sync-permissions', [UserPermissionController::class, 'syncPermissions']);
    Route::get('/users/{id}/permissions', [UserPermissionController::class, 'getPermissions']);

   
    Route::apiResource('designations', DesignationController::class);
    Route::apiResource('employees', EmployeeDetailController::class);
    Route::apiResource('customers', CustomerController::class);
    Route::apiResource('suppliers', SupplierController::class);
    Route::apiResource('brands', BrandController::class);
    Route::apiResource('categories', CategoryController::class);
    Route::apiResource('products', ProductController::class);

    // Stock Management API
    Route::post('/stocks/in', [StockController::class, 'stockIn']);
    Route::post('/stocks/out', [StockController::class, 'stockOut']);
    Route::get('/stocks/history', [StockController::class, 'history']);
    Route::get('/products/{id}/stock-history', [StockController::class, 'productHistory']);

    Route::apiResource('orders', OrderController::class);
    Route::post('/orders/{id}/approve', [OrderController::class, 'approve']);

    // Employee Supervisor Assignment
    Route::post('/employees/{id}/assign-supervisor', [EmployeeDetailController::class, 'assignSupervisor']);

    // Reports
    Route::get('/reports/customer', [ReportController::class, 'customerSalesReport']);
    Route::get('/reports/product', [ReportController::class, 'productSalesReport']);
    Route::get('/reports/category', [ReportController::class, 'categorySalesReport']);
    Route::get('/reports/payment-method', [ReportController::class, 'paymentMethodReport']);
    Route::get('/reports/officer', [ReportController::class, 'officerSalesReport']);
    Route::get('/reports/manager', [ReportController::class, 'managerSalesReport']);
    Route::get('/reports/rsm', [ReportController::class, 'rsmSalesReport']);
    Route::get('/reports/others', [ReportController::class, 'otherEmployeesSalesReport']);

    // Dashboard Routes
    Route::get('/dashboard/all', [DashboardController::class, 'getAll']);
    Route::get('/dashboard/stats', [DashboardController::class, 'getStats']);
    Route::get('/dashboard/charts', [DashboardController::class, 'getCharts']);
    Route::get('/dashboard/top-products', [DashboardController::class, 'getTopProducts']);
    Route::get('/dashboard/recent-orders', [DashboardController::class, 'getRecentOrders']);

    // Notifications
    Route::get('/notifications', [NotificationController::class, 'index']);
    Route::get('/notifications/unread', [NotificationController::class, 'unread']);
    Route::post('/notifications/{id}/read', [NotificationController::class, 'markAsRead']);
    Route::post('/notifications/read-all', [NotificationController::class, 'markAllAsRead']);

    // Office Costs
    Route::apiResource('expense-categories', ExpenseCategoryController::class);
    Route::apiResource('expenses', ExpenseController::class);
});
